import{Fragment,h,Host}from"@stencil/core";import{__,sprintf,_n}from"@wordpress/i18n";import{openWormhole}from"stencil-wormhole";import{isPriceInOrder}from"../../../../functions/line-items";import{intervalString}from"../../../../functions/price";import{getPricesAndProducts}from"../../../../services/fetch";export class ScPriceChoice{constructor(){this.priceId=void 0,this.price=void 0,this.product=void 0,this.loading=!1,this.label=void 0,this.showLabel=!0,this.showPrice=!0,this.showControl=!0,this.description=void 0,this.prices={},this.products={},this.order=void 0,this.quantity=1,this.type=void 0,this.checked=!1,this.error=void 0,this.isAdHoc=void 0,this.blank=!1,this.errorMessage=void 0,this.adHocErrorMessage=void 0}handlePriceIdChage(){var e;this.price&&(null===(e=this.price)||void 0===e?void 0:e.id)===this.priceId||this.fetchPriceWithProduct()}handlePricesChange(){var e,t,i;Object.keys(this.prices||{}).length&&Object.keys(this.products||{}).length&&(this.price=null===(e=null==this?void 0:this.prices)||void 0===e?void 0:e[this.priceId],this.product=null===(t=null==this?void 0:this.products)||void 0===t?void 0:t[null===(i=null==this?void 0:this.price)||void 0===i?void 0:i.product])}handlePriseChange(){var e;this.isAdHoc=null===(e=null==this?void 0:this.price)||void 0===e?void 0:e.ad_hoc}handleErrorsChange(){var e;const t=((null===(e=null==this?void 0:this.error)||void 0===e?void 0:e.additional_errors)||[]).find((e=>{var t;return"line_items.ad_hoc_amount"===(null===(t=null==e?void 0:e.data)||void 0===t?void 0:t.attribute)}));this.adHocErrorMessage=(null==t?void 0:t.message)?null==t?void 0:t.message:""}handleCheckedChange(){var e;(null===(e=this.price)||void 0===e?void 0:e.ad_hoc)&&this.choice.checked&&setTimeout((()=>{this.adHocInput.triggerFocus()}),50)}componentWillLoad(){this.price||this.fetchPriceWithProduct()}async fetchPriceWithProduct(){if(this.priceId)try{this.loading=!0;const{products:e,prices:t}=await getPricesAndProducts({archived:!1,ids:[this.priceId]});this.scAddEntities.emit({prices:t,products:e})}catch(e){}finally{this.loading=!1}}isInOrder(){return isPriceInOrder(this.price,this.order)}isChecked(){return this.isInOrder()}onChangeAdHoc(e){this.scUpdateLineItem.emit({price_id:this.priceId,quantity:this.quantity,ad_hoc_amount:e.target.value})}getLineItem(){var e,t;return((null===(t=null===(e=this.order)||void 0===e?void 0:e.line_items)||void 0===t?void 0:t.data)||[]).find((e=>e.price.id===this.priceId))}showAdHoc(){var e,t;return!!(null===(e=this.price)||void 0===e?void 0:e.ad_hoc)&&(!!this.isInOrder()||(null===(t=null==this?void 0:this.choice)||void 0===t?void 0:t.checked))}renderEmpty(){var e;return(null===(e=null===window||void 0===window?void 0:window.wp)||void 0===e?void 0:e.blocks)?h("sc-alert",{type:"danger",open:!0,style:{margin:"0px"}},__("This product has been archived.","surecart")):h(Host,{style:{display:"none"}})}renderPrice(){var e;return h(Fragment,null,null===(e=this.price)||void 0===e?void 0:e.display_amount,intervalString(this.price,{showOnce:!0,abbreviate:!0,labels:{interval:"/",period:
/** translators: used as in time period: "for 3 months" */
__("for","surecart")}}))}render(){var e,t,i,r,o,s,c,a,l,n,d;return this.loading?h("sc-choice-container",{showControl:this.showControl,name:"loading",disabled:!0},h("div",{class:"price-choice"},h("sc-skeleton",{style:{width:"60px",display:"inline-block"}}),h("sc-skeleton",{style:{width:"80px",display:"inline-block"}}))):!(null===(e=null==this?void 0:this.price)||void 0===e?void 0:e.id)||(null===(t=this.price)||void 0===t?void 0:t.archived)||(null===(i=this.product)||void 0===i?void 0:i.archived)?this.renderEmpty():h("sc-choice-container",{ref:e=>this.choice=e,value:this.priceId,type:this.type,showControl:this.showControl,checked:this.isChecked()},h("div",{class:"price-choice"},this.showLabel&&h("div",{class:"price-choice__title"},h("div",{class:"price-choice__name"},this.label||(null===(r=null==this?void 0:this.price)||void 0===r?void 0:r.name)||(null===(o=null==this?void 0:this.product)||void 0===o?void 0:o.name)),!!this.description&&h("div",{class:"price-choice__description"},this.description)),this.showPrice&&h("div",{class:"price-choice__details"},h("div",{class:"price-choice__price"},(null===(s=this.price)||void 0===s?void 0:s.ad_hoc)?__("Custom Amount","surecart"):h(Fragment,null,null===(c=this.price)||void 0===c?void 0:c.display_amount,intervalString(this.price,{showOnce:!0,abbreviate:!0,labels:{interval:"/",period:
/** translators: used as in time period: "for 3 months" */
__("for","surecart")}}))),!!this.price.trial_duration_days&&h("div",{class:"price-choice__trial"},sprintf(_n("Starting in %s day","Starting in %s days",this.price.trial_duration_days,"surecart"),this.price.trial_duration_days)),!!this.price.setup_fee_enabled&&(null===(a=this.price)||void 0===a?void 0:a.setup_fee_amount)&&h("div",{class:"price-choice__setup-fee"},null===(l=this.price)||void 0===l?void 0:l.setup_fee_display_amount," ",(null===(n=this.price)||void 0===n?void 0:n.setup_fee_name)||((null===(d=this.price)||void 0===d?void 0:d.setup_fee_amount)<0?__("Discount","surecart"):__("Setup Fee","surecart"))))))}static get is(){return"sc-price-choice"}static get originalStyleUrls(){return{$:["sc-price-choice.scss"]}}static get styleUrls(){return{$:["sc-price-choice.css"]}}static get properties(){return{priceId:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Id of the price."},attribute:"price-id",reflect:!0},price:{type:"unknown",mutable:!0,complexType:{original:"Price",resolved:"Price",references:{Price:{location:"import",path:"../../../../types",id:"src/types.ts::Price"}}},required:!1,optional:!1,docs:{tags:[],text:"Stores the price"}},product:{type:"unknown",mutable:!0,complexType:{original:"Product",resolved:"Product",references:{Product:{location:"import",path:"../../../../types",id:"src/types.ts::Product"}}},required:!1,optional:!1,docs:{tags:[],text:"Stores the price"}},loading:{type:"boolean",mutable:!0,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Is this loading"},attribute:"loading",reflect:!1,defaultValue:"false"},label:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Label for the choice."},attribute:"label",reflect:!1},showLabel:{type:"boolean",mutable:!1,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Show the label"},attribute:"show-label",reflect:!1,defaultValue:"true"},showPrice:{type:"boolean",mutable:!1,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Show the price amount"},attribute:"show-price",reflect:!1,defaultValue:"true"},showControl:{type:"boolean",mutable:!1,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Show the radio/checkbox control"},attribute:"show-control",reflect:!1,defaultValue:"true"},description:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Label for the choice."},attribute:"description",reflect:!1},prices:{type:"unknown",mutable:!1,complexType:{original:"Prices",resolved:"{ [id: string]: Price; }",references:{Prices:{location:"import",path:"../../../../types",id:"src/types.ts::Prices"}}},required:!1,optional:!1,docs:{tags:[],text:"Price entities"},defaultValue:"{}"},products:{type:"unknown",mutable:!1,complexType:{original:"Products",resolved:"{ [id: string]: Product; }",references:{Products:{location:"import",path:"../../../../types",id:"src/types.ts::Products"}}},required:!1,optional:!1,docs:{tags:[],text:"Product entity"},defaultValue:"{}"},order:{type:"unknown",mutable:!1,complexType:{original:"Checkout",resolved:"Checkout",references:{Checkout:{location:"import",path:"../../../../types",id:"src/types.ts::Checkout"}}},required:!1,optional:!1,docs:{tags:[],text:"Session"}},quantity:{type:"number",mutable:!1,complexType:{original:"number",resolved:"number",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Default quantity"},attribute:"quantity",reflect:!1,defaultValue:"1"},type:{type:"string",mutable:!1,complexType:{original:"'checkbox' | 'radio'",resolved:'"checkbox" | "radio"',references:{}},required:!1,optional:!1,docs:{tags:[],text:"Choice Type"},attribute:"type",reflect:!1},checked:{type:"boolean",mutable:!0,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Is this checked by default"},attribute:"checked",reflect:!0,defaultValue:"false"},error:{type:"unknown",mutable:!1,complexType:{original:"ResponseError",resolved:"ResponseError",references:{ResponseError:{location:"import",path:"../../../../types",id:"src/types.ts::ResponseError"}}},required:!1,optional:!1,docs:{tags:[],text:"Errors from response"}},isAdHoc:{type:"unknown",mutable:!0,complexType:{original:"Boolean",resolved:"Boolean",references:{Boolean:{location:"global",id:"global::Boolean"}}},required:!1,optional:!1,docs:{tags:[],text:"Is this an ad-hoc price choice"}},blank:{type:"boolean",mutable:!1,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Is this blank?"},attribute:"blank",reflect:!1,defaultValue:"false"}}}static get states(){return{errorMessage:{},adHocErrorMessage:{}}}static get events(){return[{method:"scUpdateLineItem",name:"scUpdateLineItem",bubbles:!0,cancelable:!0,composed:!0,docs:{tags:[],text:"Toggle line item event"},complexType:{original:"LineItemData",resolved:"LineItemData",references:{LineItemData:{location:"import",path:"../../../../types",id:"src/types.ts::LineItemData"}}}},{method:"scRemoveLineItem",name:"scRemoveLineItem",bubbles:!0,cancelable:!0,composed:!0,docs:{tags:[],text:"Toggle line item event"},complexType:{original:"LineItemData",resolved:"LineItemData",references:{LineItemData:{location:"import",path:"../../../../types",id:"src/types.ts::LineItemData"}}}},{method:"scAddEntities",name:"scAddEntities",bubbles:!0,cancelable:!0,composed:!0,docs:{tags:[],text:"Add entities"},complexType:{original:"any",resolved:"any",references:{}}}]}static get watchers(){return[{propName:"priceId",methodName:"handlePriceIdChage"},{propName:"prices",methodName:"handlePricesChange"},{propName:"products",methodName:"handlePricesChange"},{propName:"price",methodName:"handlePriseChange"},{propName:"error",methodName:"handleErrorsChange"},{propName:"checked",methodName:"handleCheckedChange"}]}}openWormhole(ScPriceChoice,["prices","products","order","error"],!1);