<div id="sc-elementor-modal-dialog" class="sc-elementor-modal" role="dialog" aria-labelledby="sc-elementor-modal-title" aria-modal="true" hidden>
	<div class="sc-elementor-modal__overlay" tabindex="-1" aria-hidden="true"></div>
	<div class="sc-elementor-modal__content">
		<div class="sc-elementor-modal__header">
			<h2 id="sc-elementor-modal-title" class="sc-elementor-modal__title">
				<svg viewBox="0 0 174 32" fill="none" xmlns="http://www.w3.org/2000/svg" width="125">
					<path fill-rule="evenodd" clip-rule="evenodd" d="M40.2246 22.5298L41.6057 20.5358C42.2395 21.2544 43.0826 21.8591 44.1348 22.3501C45.1871 22.8411 46.2932 23.0866 47.4532 23.0866C48.7805 23.0866 49.8149 22.8052 50.5562 22.2423C51.3096 21.6795 51.6863 20.943 51.6863 20.0328C51.6863 19.458 51.483 18.973 51.0764 18.5778C50.6698 18.1826 50.1437 17.8772 49.498 17.6616C48.8522 17.4461 48.1407 17.2485 47.3635 17.0689C46.5862 16.8892 45.803 16.6796 45.0138 16.4401C44.2365 16.2006 43.525 15.9072 42.8793 15.5599C42.2335 15.2126 41.7074 14.7216 41.3008 14.0869C40.8942 13.4402 40.691 12.6738 40.691 11.7876C40.691 10.3265 41.2769 9.11101 42.4488 8.14098C43.6207 7.15897 45.229 6.66797 47.2738 6.66797C49.9763 6.66797 52.1646 7.53022 53.8387 9.25472L52.5652 11.1589C52.0151 10.4882 51.2737 9.94931 50.341 9.54213C49.4202 9.12299 48.3978 8.91341 47.2738 8.91341C46.09 8.91341 45.1393 9.18286 44.4218 9.72177C43.7044 10.2487 43.3456 10.9133 43.3456 11.7157C43.3456 12.2307 43.5489 12.6678 43.9555 13.0271C44.362 13.3744 44.8822 13.6498 45.516 13.8534C46.1617 14.045 46.8732 14.2306 47.6505 14.4103C48.4397 14.5779 49.2229 14.7875 50.0002 15.039C50.7894 15.2905 51.5009 15.6018 52.1347 15.9731C52.7804 16.3323 53.3066 16.8533 53.7131 17.5359C54.1197 18.2185 54.323 19.0269 54.323 19.961C54.323 21.5178 53.7131 22.8052 52.4934 23.8231C51.2857 24.8291 49.5817 25.3321 47.3814 25.3321C44.4039 25.3321 42.0183 24.398 40.2246 22.5298ZM57.3378 19.6556V7.11706H60.0822V18.8113C60.0822 20.2963 60.423 21.3442 61.1046 21.9549C61.7862 22.5537 62.7787 22.8531 64.0821 22.8531C65.1105 22.8531 66.103 22.5956 67.0596 22.0807C68.0162 21.5657 68.7636 20.931 69.3017 20.1765V7.11706H72.064V24.883H69.3017V22.3861C68.5603 23.2244 67.6336 23.9249 66.5215 24.4878C65.4094 25.0506 64.2316 25.3321 62.9879 25.3321C59.2212 25.3321 57.3378 23.4399 57.3378 19.6556ZM76.1012 24.883H78.8456V12.3085C79.2521 11.578 79.9517 10.9253 80.9442 10.3505C81.9367 9.76368 82.8575 9.47028 83.7065 9.47028C83.9815 9.47028 84.3343 9.49423 84.7647 9.54213V6.7039C83.6168 6.7039 82.5346 7.00329 81.5182 7.60207C80.5017 8.18888 79.6109 8.97329 78.8456 9.9553V7.11706H76.1012V24.883ZM85.7168 15.9731C85.7168 14.2725 86.0875 12.7157 86.8289 11.3026C87.5823 9.87745 88.6286 8.75174 89.9679 7.92542C91.3072 7.08712 92.8079 6.66797 94.47 6.66797C96.2159 6.66797 97.7405 7.09311 99.0439 7.94338C100.347 8.79365 101.328 9.93733 101.986 11.3744C102.655 12.7995 102.99 14.4102 102.99 16.2066V16.9072H88.6585C88.7661 18.6556 89.3879 20.1167 90.5239 21.2903C91.6719 22.4639 93.1666 23.0507 95.0081 23.0507C96.0485 23.0507 97.047 22.8531 98.0036 22.4579C98.9722 22.0627 99.8152 21.4999 100.533 20.7693L101.842 22.5657C99.9647 24.4099 97.615 25.3321 94.7929 25.3321C92.1382 25.3321 89.9619 24.4638 88.2639 22.7274C86.5658 20.9909 85.7168 18.7395 85.7168 15.9731ZM88.6226 14.8414H100.264C100.252 14.1588 100.126 13.4821 99.887 12.8115C99.6598 12.1409 99.319 11.5121 98.8646 10.9253C98.4102 10.3385 97.8003 9.86548 97.035 9.50621C96.2697 9.13496 95.4027 8.94934 94.4341 8.94934C93.5253 8.94934 92.7003 9.12897 91.9589 9.48824C91.2175 9.84751 90.6136 10.3206 90.1472 10.9074C89.6928 11.4822 89.3341 12.1109 89.071 12.7935C88.8079 13.4642 88.6585 14.1468 88.6226 14.8414ZM123.25 20.896C121.985 23.1411 119.696 25.3321 115.766 25.3321C110.354 25.3321 106.182 21.5452 106.182 16C106.182 10.4278 110.354 6.66797 115.766 6.66797C119.696 6.66797 121.985 8.80487 123.25 11.077L119.965 12.7C119.212 11.2393 117.596 10.0762 115.766 10.0762C112.481 10.0762 110.112 12.5918 110.112 16C110.112 19.4082 112.481 21.9238 115.766 21.9238C117.596 21.9238 119.212 20.7607 119.965 19.3001L123.25 20.896ZM135.168 6.96551L142.087 25.0075H137.752L136.622 21.9509H128.922L127.791 25.0075H123.457L130.376 6.96551H135.168ZM129.972 18.5697H135.572L132.772 10.8065L129.972 18.5697ZM158.31 25.0075L154.245 18.1369C156.183 17.6771 158.202 15.9459 158.202 12.7811C158.202 9.42701 155.887 6.96551 152.145 6.96551H143.745V25.0075H147.568V18.5968H150.368L153.895 25.0075H158.31ZM151.606 15.2156H147.568V10.3467H151.606C153.114 10.3467 154.271 11.2664 154.271 12.7541C154.271 14.2959 153.114 15.2156 151.606 15.2156ZM168.777 10.3467V25.0075H164.927V10.3467H159.678V6.96551H174V10.3467H168.777Z" fill="#fff"/>
					<path fill-rule="evenodd" clip-rule="evenodd" d="M15.9573 31.9978C24.7703 31.9978 31.9146 24.8353 31.9146 16C31.9146 7.16466 24.7703 0.00219727 15.9573 0.00219727C7.14433 0.00219727 0 7.16466 0 16C0 24.8353 7.14433 31.9978 15.9573 31.9978ZM16.026 8.0011C14.7447 8.0011 12.9716 8.73571 12.0655 9.6419L9.60482 12.1031H21.8701L25.9713 8.0011H16.026ZM19.8284 22.3581C18.9224 23.2643 17.1492 23.9989 15.8679 23.9989H5.92266L10.0239 19.8969H22.2891L19.8284 22.3581ZM23.8147 14.1541H7.55865L6.79078 14.9232C4.97257 16.564 5.51182 17.8459 8.05815 17.8459H24.3582L25.1263 17.0768C26.9269 15.4456 26.361 14.1541 23.8147 14.1541Z" fill="#fff"/>
				</svg>
			</h2>

			<button id="sc-elementor-modal-close" class="sc-elementor-modal__close" aria-label="<?php esc_attr_e( 'Close dialog', 'surecart' ); ?>">
				<?php echo wp_kses( \SureCart::svg()->get( 'x', [ 'class' => '' ] ), sc_allowed_svg_html() ); ?>
			</button>
		</div>

		<div class="sc-elementor-modal__card-container">
			<?php foreach ( $templates as $template_key => $template ) : ?>
				<div class="sc-elementor-modal__card" data-template-key="<?php echo esc_attr( $template_key ); ?>" data-template-type="<?php echo esc_attr( $template['type'] ?? '' ); ?>" tabindex="0" role="button" aria-label="<?php echo esc_attr( $template['name'] ); ?>">
					<img src="<?php echo esc_url( $template['image'] ); ?>" alt="<?php echo esc_attr( $template['name'] ); ?>" />
					<div class="sc-elementor-modal__card-actions">
						<h4 class="sc-elementor-modal__card-title"><?php echo esc_html( $template['name'] ); ?></h4>
						<a class="elementor-button e-primary">
							<i class="eicon-file-download" aria-hidden="true"></i>
							<span class="elementor-button-title"><?php esc_html_e( 'Insert', 'surecart' ); ?></span>
						</a>
					</div>
				</div>
			<?php endforeach; ?>

			<?php if ( empty( $templates ) ) : ?>
				<p><?php esc_html_e( 'No templates found.', 'surecart' ); ?></p>
			<?php endif; ?>
		</div>
	</div>
</div>
